/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public abstract class FeaturePlacementRitual
extends AbstractRitual {
    public Map<String, List<BlockPos>> featureMap = new HashMap<String, List<BlockPos>>();
    public int checkRadius = 7;
    public int featureIndex = 0;
    public int positionIndex = 0;
    public List<BlockPos> targetPositions = new ArrayList<BlockPos>();
    public List<IPlaceableFeature> features = new ArrayList<IPlaceableFeature>();
    public BlockPos lowerOffset = BlockPos.ZERO;
    public BlockPos upperOffset = BlockPos.ZERO;

    public abstract void addFeatures(List<IPlaceableFeature> var1);

    @Override
    public void onStart(@Nullable Player player) {
        super.onStart(player);
        for (ItemStack i : this.getConsumedItems()) {
            if (!i.is(ItemTagProvider.SOURCE_GEM_TAG)) continue;
            this.checkRadius += i.getCount();
        }
        this.setup();
    }

    public void setup() {
        this.addFeatures(this.features);
        for (IPlaceableFeature feature : this.features) {
            this.featureMap.put(feature.getFeatureName(), new ArrayList());
        }
        this.targetPositions = this.getTargetPositions();
    }

    public List<BlockPos> getTargetPositions() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos pos = this.getPos();
        Pair<BlockPos, BlockPos> offsets = this.features.get(this.featureIndex).getCustomOffsets();
        BlockPos lowerBound = this.getPos().offset(-this.checkRadius, 0, -this.checkRadius).offset((Vec3i)this.lowerOffset).offset((Vec3i)offsets.getA());
        BlockPos upperBound = this.getPos().offset(this.checkRadius, 0, this.checkRadius).offset((Vec3i)this.upperOffset).offset((Vec3i)offsets.getB());
        for (BlockPos nextPos : BlockPos.betweenClosed((BlockPos)lowerBound, (BlockPos)upperBound)) {
            double z;
            double y;
            double x = (double)nextPos.getX() + 0.5;
            double dist = BlockUtil.distanceFrom(new Vec3(x, y = (double)nextPos.getY() + 0.5, z = (double)nextPos.getZ() + 0.5), new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5));
            if (!(dist <= (double)this.checkRadius)) continue;
            positions.add(nextPos.immutable());
        }
        Collections.shuffle(positions);
        return positions;
    }

    @Override
    public void tick() {
        if (this.getWorld().isClientSide) {
            return;
        }
        while (true) {
            if (this.positionIndex >= this.targetPositions.size()) {
                ++this.featureIndex;
                if (this.featureIndex >= this.features.size()) {
                    this.setFinished();
                    return;
                }
                this.targetPositions = this.getTargetPositions();
                this.positionIndex = 0;
            }
            BlockPos targetPos = this.targetPositions.get(this.positionIndex);
            IPlaceableFeature feature = this.features.get(this.featureIndex);
            if (this.isEnoughBlocksFrom(feature.getFeatureName(), targetPos, feature.distanceFromOthers()) && feature.onPlace(this.getWorld(), targetPos, this, this.tile)) {
                this.featureMap.computeIfAbsent(feature.getFeatureName(), k -> new ArrayList()).add(targetPos.immutable());
                return;
            }
            ++this.positionIndex;
        }
    }

    public boolean isEnoughBlocksFrom(String feature, BlockPos targetPos, double dist) {
        if (!this.featureMap.containsKey(feature)) {
            return true;
        }
        for (BlockPos pos : this.featureMap.get(feature)) {
            Vec3 vec3 = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            Vec3 vec32 = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5);
            if (!(BlockUtil.distanceFrom(vec3, vec32) <= dist)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return stack.is(ItemTagProvider.SOURCE_GEM_TAG);
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        super.read(provider, tag);
        this.featureIndex = tag.getInt("featureIndex");
        this.positionIndex = tag.getInt("positionIndex");
        this.checkRadius = tag.getInt("checkRadius");
        this.setup();
    }

    @Override
    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        super.write(provider, tag);
        tag.putInt("featureIndex", this.featureIndex);
        tag.putInt("positionIndex", this.positionIndex);
        tag.putInt("checkRadius", this.checkRadius);
    }
}

